
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
---                                VISTA DEL MODELLO IVA, DELLA COMUNICAZIONE ANNUALE E DEI RIMBORSI IVA INFRANNUALI (Second Edition)                                 ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 07/04/2021 Occhialini Lorenzo: Implementazione N.159780 del 07/04/2021 - Fase 159788                                                                              ---
--- Lettura del codice fiscale dell'anagrafica necessario per escludere gli enti pubblici senza partita IVA dai dati del quadro VT.                                   ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 24/05/2017 Occhialini Lorenzo: Anomalia N.73741 del 22/02/2017 - Fase 74855                                                                                       ---
--- Lettura dell'anagrafica valida alla data dalla vista VCG16_ANAGRALLADATA.                                                                                         ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 22/05/2017 Occhialini Lorenzo: Anomalia N.73536 del 21/02/2017 - Fase 74861                                                                                       ---
--- Inserito il conteggio per la valorizzazione dell'imposta indeducibile nei pagamenti delle fatture con iva ad esigibilit differita (tipodoc S)                    ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 17/10/2016 Occhialini Lorenzo: Implementazione N.61612 del 11/10/2016 - Fase 61619                                                                                ---
--- Inserita la condizione sul campo CG68_FLGNOLIQIVA per non considerare i record della CG43_MOVIVA di sezionali di tipologia IVA ma che non devono essere           ---
--- considerati nelle elaborazioni IVA                                                                                                                                ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 08/04/2015 Occhialini Lorenzo: Implementazione TFS N.20323 del 16/11/2015                                                                                         ---
--- Aggiunta la lettura dei dati del Mini One Stop Shop (MOSS) dalla tabella dei codici IVA                                                                           ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 10/07/2015 Occhialini Lorenzo:                                                                                                                                    ---
--- Sostituita la LEFT OUTER JOIN sulla tabella degli stati esteri con la OUTER APPLY sulla function table DBO.FNCG07_TABSTATIEST(CodiceStatoEstero, Ditta)           ---
--- dove viene eseguita la rideterminazione del valore del campo tipo stato estero (CG07_INDTIPOSTATO)                                                                ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 27/04/2015 Occhialini Lorenzo: Implementazione N.1946 del 20/04/2015                                                                                              ---
--- Considera sempre il sezionale del documento nei record di TIPO 'S' e 'E'                                                                                          ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 04/03/2013 Occhialini Lorenzo: Variazione Funzionale N.5031 del 28/02/2013 - Attivit 198625                                                                      ---
--- Inserito il campo CG16_PARTIVA_EST in combinazione con CG16_PARTIVA necessario all'individuazione del tipo di anagrafica nel quadro VT (per le versioni           ---
--- precedenti alla 05.00.00 ripristinare la riga precedente)                                                                                                         ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 17/12/2012 Occhialini Lorenzo: Richieste di Implementazioni N.3286 del 15/07/2005 - Attivit 7263                                                                 ---
--- Inserito il campo CG41_RIFFIGLIA e modificate le sezioni 'S' ed 'E' per prelevare il CG41_INDTIPOREG dal documento origine                                        ---                                                                                      --- 
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 05/11/2012 Occhialini Lorenzo: Richieste di Implementazioni N.11456 del 03/09/2012 - Attivit 167851                                                              ---
--- Inserita la lettura del tipo INTRA 12 e INTRA 13 dalla tabella dei sezionali                                                                                      ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--- 09/07/2012 Occhialini Lorenzo: Variazione Funzionale N.4630 del 15/06/2012 - Attivit 162562                                                                      ---
--- Modificata la JOIN dei records di tipo 'P' riferita alla tabella CG86_AZIENDECOLL per il prelievo delle propriet relative all'attivit per anno                  ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
---	24/05/2010 Occhialini Lorenzo:                                                                                                                                    ---
--- Release iniziale                                                                                                                                                  ---
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE ID = OBJECT_ID(N'[dbo].[VCG41_MODELLOIVA_SE]') AND OBJECTPROPERTY(ID, N'ISVIEW') = 1)
	DROP VIEW [dbo].[VCG41_MODELLOIVA_SE]
GO

SET QUOTED_IDENTIFIER  OFF
SET ANSI_NULLS  ON
GO

CREATE VIEW dbo.VCG41_MODELLOIVA_SE
AS

---------------------------------------------------------------------
---              RECORDS DI TIPO 'P' (MOVIMENTI IVA)              ---
---------------------------------------------------------------------

SELECT          'P' AS TIPODOC,
                CG41_PRIMANOTA.CG41_DITTA_CG18,
                CG41_PRIMANOTA.CG41_FLGSTPIVA,
                CG41_PRIMANOTA.CG41_NUMREG,
                CG41_PRIMANOTA.CG41_DATAREG,
                CG41_PRIMANOTA.CG41_ANNO_CG19,
                CG41_PRIMANOTA.CG41_PROGESER_CG19,
                CG41_PRIMANOTA.CG41_INDTIPOREG,
                CG41_PRIMANOTA.CG41_SEZIONALE,
                CG68_NUMERDESC.CG68_INDREGIONE,
                CG41_PRIMANOTA.CG41_CODICE_CG33,
                ISNULL(CG33_TABCAU.CG33_CAUSALEIVA, CG33_TABCAU.CG33_CODICE) AS CG33_CAUSALEIVA,
                CG41_PRIMANOTA.CG41_DATAREGIVA,
                CG41_PRIMANOTA.CG41_INDTIPOMOV,
                CG43_MOVIVA.CG43_ALIQIVA1_CG28,
                CG43_MOVIVA.CG43_ALIQIVA2_CG28,
                ISNULL((CASE CG41_PRIMANOTA.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CG43_MOVIVA.CG43_IMPONIBILE
                        ELSE CG43_MOVIVA.CG43_IMPONIBILE END), 0) AS CG43_IMPONIBILE,
                ISNULL((CASE CG41_PRIMANOTA.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CG43_MOVIVA.CG43_IMPOSTA
                        ELSE CG43_MOVIVA.CG43_IMPOSTA END), 0) AS CG43_IMPOSTA,
                ISNULL((CASE CG41_PRIMANOTA.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CG43_MOVIVA.CG43_IMPOSTAND
                        ELSE CG43_MOVIVA.CG43_IMPOSTAND END), 0) AS CG43_IMPOSTAND,
                CG41_PRIMANOTA.CG41_FLGSEGNOIVA,
                CG43_MOVIVA.CG43_NUMRIGAIVA,
                CG43_MOVIVA.CG43_INDTIPO,
      	        CG43_MOVIVA.CG43_CAUSALEIVA,
                CG43_MOVIVA.CG43_INDDETRIVA,
                CG43_MOVIVA.CG43_INDPRORATA,
                CG28_TABCODIVA.CG28_DESCR,
                CG28_TABCODIVA.CG28_TIPOLOGIA,
                CG28_TABCODIVA.CG28_PERCIVA,
                CG28_TABCODIVA.CG28_ALIQIVAVENT,
                CG28_TABCODIVA.CG28_FLGCORRVENT,
                CG28_TABCODIVA.CG28_FLGINDET,
                CG28_TABCODIVA.CG28_PERCINDET,
                CG28_TABCODIVA.CG28_CODPLAFOND,
                CG28_TABCODIVA.CG28_INDTIPOPART,
		        CASE WHEN CG43_MOVIVA.CG43_INDTIPO <> 56
                     THEN CG28_TABCODIVA.CG28_PERCFORF
                     ELSE ISNULL(CG28_TABCODIVA.CG28_PERCFORF, ISNULL(CG86_AZIENDECOLL.CG86_PERCDETRIVA, 0)) END AS CG28_PERCFORF,
                CG28_TABCODIVA.CG28_FLGAUTOUE,
                CG28_TABCODIVA.CG28_FLGNOTVAR,
                CG28_TABCODIVA.CG28_FLGAGRI,
                CG28_TABCODIVA.CG28_FLGESCLUDIBLACKLIST,
				CG28_TABCODIVA.CG28_FLGMOSSGEST,
				CG28_TABCODIVA.CG28_MOSSPERC,
				CG28_TABCODIVA.CG28_FLGMOSSRID,
				CG28_TABCODIVA.CG28_MOSSCOD_CG07,
				CG07_MOSS.CG07_DESCR AS CG07_MOSSDESCR,
                TABIVAAGRI.CG28_FLGAGRI AS CG28_FLGAGRI_AGRI, 
                TABIVAAGRI.CG28_DESCR AS CG28_DESCR_AGRI, 
                TABIVAAGRI.CG28_TIPOLOGIA AS CG28_TIPOLOGIA_AGRI,	
                TABIVAAGRI.CG28_PERCIVA AS CG28_PERCIVA_AGRI, 
                TABIVAAGRI.CG28_CODPLAFOND AS CG28_CODPLAFOND_AGRI,
                TABIVAAGRI.CG28_PERCFORF AS CG28_PERCFORF_AGRI,
                NULL AS CG41_DTREGIVAORIG,
                CG41_PRIMANOTA.CG41_NUMDOC,
                CG41_PRIMANOTA.CG41_NUMDOCORIG,
                CG41_PRIMANOTA.CG41_DATADOC,
                CG41_PRIMANOTA.CG41_DITTACF_CG18,
                CG41_PRIMANOTA.CG41_TIPOCF_CG44,
                CG41_PRIMANOTA.CG41_CLIFOR_CG44,
                VCG16_ANAGRALLADATA.CG44_CODICE_CG16,
                ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAG), '') + ' ' + ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAGEX), '') AS CG16_RAGSOANAG,
                VCG16_ANAGRALLADATA.CG16_CODICE_CG07,
                VCG16_ANAGRALLADATA.CG16_FLGNOBLACKLIST,
      	        ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) AS CG07_INDTIPOSTATO,
                CG07_TABSTATIEST.CG07_DATACEE,
                CG07_TABSTATIEST.CG07_DATAINIBLACKLIST,
                CG07_TABSTATIEST.CG07_DATAFINBLACKLIST,
                CAST(CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0
                          THEN VCG16_ANAGRALLADATA.CG16_PARTIVA_EST
                          ELSE VCG16_ANAGRALLADATA.CG16_PARTIVA END AS VARCHAR(20)) AS CG16_PARTIVA,
                VCG16_ANAGRALLADATA.CG16_CODFISCALE AS CG16_CODFISCALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALE, 0) AS CG41_IMPTOTALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALEVAL, 0) AS CG41_IMPTOTALEVAL,
                CG41_PRIMANOTA.CG41_CODICE_CG08,
                CG41_PRIMANOTA.CG41_FLGDOCBIS,
                CG41_PRIMANOTA.CG41_RIFPADRE,
                CG41_PRIMANOTA.CG41_RIFFIGLIA,
                CG41_PRIMANOTA.CG41_TIPODOC,
                CG41_PRIMANOTA.CG41_FLGSTPTOTIVA,
                CG41_PRIMANOTA.CG41_DATADOCRIFNOTEVAR,
                CG41_PRIMANOTA.CG41_CODICE_CG31,
                CG41_PRIMANOTA.CG41_ANAGBLACKLIST_CG16,
                NULL AS CGM2_INDTIPOMOV,
                NULL AS CGM2_PERCFORF,
                NULL AS CGM2_MARGINE,
                NULL AS CGM2_RETTCOSTO,
                CG68_NUMERDESC.CG68_PUNTOVEN_CG7A,
                CG68_NUMERDESC.CG68_INDINTRA1213,
		        CASE WHEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, 0) <> 0
		             THEN CG86_AZIENDECOLL.CG86_CODATTIVITA
		             ELSE CG41_PRIMANOTA.CG41_DITTA_CG18 END AS CG86_CODATTIVITA
FROM            CG41_PRIMANOTA WITH(NOLOCK)
INNER JOIN      CG43_MOVIVA WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG43_MOVIVA.CG43_DITTA_CG18
            AND CG41_PRIMANOTA.CG41_NUMREG = CG43_MOVIVA.CG43_NUMREG_CG41
INNER JOIN      CG28_TABCODIVA WITH(NOLOCK)
             ON CG43_MOVIVA.CG43_ALIQIVA1_CG28 = CG28_TABCODIVA.CG28_CODICE
LEFT OUTER JOIN CG28_TABCODIVA AS TABIVAAGRI WITH(NOLOCK)
             ON CG43_MOVIVA.CG43_ALIQIVA2_CG28 = TABIVAAGRI.CG28_CODICE
INNER JOIN      CG33_TABCAU WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_CODICE_CG33 = CG33_TABCAU.CG33_CODICE
LEFT OUTER JOIN VCG16_ANAGRALLADATA
             ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTACF_CG18
            AND VCG16_ANAGRALLADATA.CG44_TIPOCF = CG41_PRIMANOTA.CG41_TIPOCF_CG44
            AND VCG16_ANAGRALLADATA.CG44_CLIFOR = CG41_PRIMANOTA.CG41_CLIFOR_CG44
            AND ISNULL(CG41_PRIMANOTA.CG41_DATADOC, CG41_PRIMANOTA.CG41_DATAREG) BETWEEN ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, '17530101')
                                                                                     AND ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, '99991231')
OUTER APPLY     DBO.FNCG07_TABSTATIEST(VCG16_ANAGRALLADATA.CG16_CODICE_CG07, CG41_PRIMANOTA.CG41_DITTA_CG18) AS CG07_TABSTATIEST
OUTER APPLY     DBO.FNCG07_TABSTATIEST(CG28_TABCODIVA.CG28_MOSSCOD_CG07, CG41_PRIMANOTA.CG41_DITTA_CG18) AS CG07_MOSS
LEFT OUTER JOIN CG68_NUMERDESC WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG68_NUMERDESC.CG68_DITTA_CG18
            AND CG41_PRIMANOTA.CG41_SEZIONALE = CG68_NUMERDESC.CG68_SEZIONALE
LEFT OUTER JOIN CG32_ANADITTAPSEZ WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18
            AND YEAR(ISNULL(CG41_PRIMANOTA.CG41_DATAREGIVA, CG41_PRIMANOTA.CG41_DATAREG)) = CG32_ANADITTAPSEZ.CG32_ANNO
            AND CG41_PRIMANOTA.CG41_SEZIONALE = CG32_ANADITTAPSEZ.CG32_SEZIONALE
LEFT OUTER JOIN CG86_AZIENDECOLL WITH(NOLOCK)
             ON CG86_AZIENDECOLL.CG86_IDATTIVITA = CASE WHEN ISNULL(CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86, 0) <> 0
                                                        THEN CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86
                                                        ELSE (SELECT TOP 1    A.CG86_IDATTIVITA
                                                              FROM            CG86_AZIENDECOLL AS A WITH(NOLOCK)
                                                              LEFT OUTER JOIN CG25_ANADITTAGEST WITH(NOLOCK)
                                                                           ON CG25_ANADITTAGEST.CG25_DITTA_CG18 = A.CG86_DITTACOLL_CG18
                                                              WHERE           A.CG86_DITTACOLL_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18
                                                                          AND A.CG86_ANNOIVA = CG32_ANADITTAPSEZ.CG32_ANNO
                                                                          AND CG25_ANADITTAGEST.CG25_FLGIVAQUATER IN(0, 1)
                                                                          AND A.CG86_INDTIPO = 0) END
WHERE           CG43_MOVIVA.CG43_INDTIPO NOT IN (19, 30, 31, 32, 33, 34)
            AND CG68_NUMERDESC.CG68_FLGNOLIQIVA = 0

---------------------------------------------------------------------
---       RECORDS DI TIPO 'S' (RISCOSSIONI FATTURE SOSPESE)       ---
---------------------------------------------------------------------
UNION ALL

SELECT          'S' AS TIPODOC,
                CG41_PRIMANOTA.CG41_DITTA_CG18,
                CG41_PRIMANOTA.CG41_FLGSTPIVA,
                CG41_PRIMANOTA.CG41_NUMREG,
                CG41_PRIMANOTA.CG41_DATAREG,
                CG41_PRIMANOTA.CG41_ANNO_CG19,
                CG41_PRIMANOTA.CG41_PROGESER_CG19,
                PN_DOCORIG.CG41_INDTIPOREG,
                PN_DOCORIG.CG41_SEZIONALE,
                CG68_NUMERDESC.CG68_INDREGIONE,
                CG41_PRIMANOTA.CG41_CODICE_CG33,
                NULL AS CG33_CAUSALEIVA,
                CG41_PRIMANOTA.CG41_DATAREGIVA,
                CG41_PRIMANOTA.CG41_INDTIPOMOV,
                CG50_MOVPAGSOSP.CG50_CODICE_CG28 AS CG43_ALIQIVA1_CG28,
                NULL AS CG43_ALIQIVA2_CG28,
                ISNULL((CASE PN_DOCORIG.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CG50_MOVPAGSOSP.CG50_IMPONIBILE
                        ELSE CG50_MOVPAGSOSP.CG50_IMPONIBILE END), 0) AS CG43_IMPONIBILE,
                ISNULL((CASE PN_DOCORIG.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CG50_MOVPAGSOSP.CG50_IMPOSTA
                        ELSE CG50_MOVPAGSOSP.CG50_IMPOSTA END), 0) AS CG43_IMPOSTA,
				CASE ISNULL(CG28_TABCODIVA.CG28_PERCINDET, 0)
					 WHEN 0 THEN 0
					 ELSE ISNULL((CASE PN_DOCORIG.CG41_FLGSEGNOIVA
					                   WHEN 1 THEN -CAST(ROUND((ISNULL(CG50_MOVPAGSOSP.CG50_IMPONIBILE, 0) * 
					                                            ISNULL(CG28_TABCODIVA.CG28_PERCIVA, 0) / 100), 2) -
									                            ISNULL(CG50_MOVPAGSOSP.CG50_IMPOSTA, 0) AS DECIMAL(13,2))
									   ELSE CAST(ROUND((ISNULL(CG50_MOVPAGSOSP.CG50_IMPONIBILE, 0) * 
					                                    ISNULL(CG28_TABCODIVA.CG28_PERCIVA, 0) / 100), 2) -
									                    ISNULL(CG50_MOVPAGSOSP.CG50_IMPOSTA, 0) AS DECIMAL(13,2)) END), 0) END AS CG43_IMPOSTAND,
                PN_DOCORIG.CG41_FLGSEGNOIVA,
                NULL AS CG43_NUMRIGAIVA,
                CG50_MOVPAGSOSP.CG50_INDTIPO AS CG43_INDTIPO,
      	        0 AS CG43_CAUSALEIVA,
                0 AS CG43_INDDETRIVA,
                0 AS CG43_INDPRORATA,
                CG28_TABCODIVA.CG28_DESCR,
                CG28_TABCODIVA.CG28_TIPOLOGIA,
                CG28_TABCODIVA.CG28_PERCIVA,
                CG28_TABCODIVA.CG28_ALIQIVAVENT,
                CG28_TABCODIVA.CG28_FLGCORRVENT,
                CG28_TABCODIVA.CG28_FLGINDET,
                CG28_TABCODIVA.CG28_PERCINDET,
                CG28_TABCODIVA.CG28_CODPLAFOND,
                CG28_TABCODIVA.CG28_INDTIPOPART,
                CG28_TABCODIVA.CG28_PERCFORF,
                CG28_TABCODIVA.CG28_FLGAUTOUE,
                CG28_TABCODIVA.CG28_FLGNOTVAR,
                CG28_TABCODIVA.CG28_FLGAGRI,
                CG28_TABCODIVA.CG28_FLGESCLUDIBLACKLIST,
				0 AS CG28_FLGMOSSGEST,
				NULL AS CG28_MOSSPERC,
				0 AS CG28_FLGMOSSRID,
				NULL AS CG28_MOSSCOD_CG07,
				NULL AS CG07_MOSSDESCR,
                NULL AS CG28_FLGAGRI_AGRI, 
                NULL AS CG28_DESCR_AGRI, 
                NULL AS CG28_TIPOLOGIA_AGRI,	
                NULL AS CG28_PERCIVA_AGRI, 
                NULL AS CG28_CODPLAFOND_AGRI,
                NULL AS CG28_PERCFORF_AGRI,
                PN_DOCORIG.CG41_DATAREGIVA AS CG41_DTREGIVAORIG,
                PN_DOCORIG.CG41_NUMDOC,
                PN_DOCORIG.CG41_NUMDOCORIG,
                PN_DOCORIG.CG41_DATADOC,
                PN_DOCORIG.CG41_DITTACF_CG18,
                PN_DOCORIG.CG41_TIPOCF_CG44,
                PN_DOCORIG.CG41_CLIFOR_CG44,
                VCG16_ANAGRALLADATA.CG44_CODICE_CG16,
                ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAG), '') + ' ' + ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAGEX), '') AS CG16_RAGSOANAG,
                VCG16_ANAGRALLADATA.CG16_CODICE_CG07,
                VCG16_ANAGRALLADATA.CG16_FLGNOBLACKLIST,
      	        ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) AS CG07_INDTIPOSTATO,
                CG07_TABSTATIEST.CG07_DATACEE,
                CG07_TABSTATIEST.CG07_DATAINIBLACKLIST,
                CG07_TABSTATIEST.CG07_DATAFINBLACKLIST,
                CAST(CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0
                          THEN VCG16_ANAGRALLADATA.CG16_PARTIVA_EST
                          ELSE VCG16_ANAGRALLADATA.CG16_PARTIVA END AS VARCHAR(20)) AS CG16_PARTIVA,
				VCG16_ANAGRALLADATA.CG16_CODFISCALE AS CG16_CODFISCALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALE, 0) AS CG41_IMPTOTALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALEVAL, 0) AS CG41_IMPTOTALEVAL,
                CG41_PRIMANOTA.CG41_CODICE_CG08,
                CG41_PRIMANOTA.CG41_FLGDOCBIS,
                CG41_PRIMANOTA.CG41_RIFPADRE,
                CG41_PRIMANOTA.CG41_RIFFIGLIA,
                CG41_PRIMANOTA.CG41_TIPODOC,
                CG41_PRIMANOTA.CG41_FLGSTPTOTIVA,
                CG41_PRIMANOTA.CG41_DATADOCRIFNOTEVAR,
                CG41_PRIMANOTA.CG41_CODICE_CG31,
                CG41_PRIMANOTA.CG41_ANAGBLACKLIST_CG16,
                NULL AS CGM2_INDTIPOMOV,
                NULL AS CGM2_PERCFORF,
                NULL AS CGM2_MARGINE,
                NULL AS CGM2_RETTCOSTO,
                CG68_NUMERDESC.CG68_PUNTOVEN_CG7A,
                CG68_NUMERDESC.CG68_INDINTRA1213,
		        CASE WHEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, 0) <> 0
                     THEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, CG41_PRIMANOTA.CG41_DITTA_CG18)
                     ELSE ISNULL((SELECT TOP 1 (DITTACOLL.CG86_CODATTIVITA)
                                  FROM   CG86_AZIENDECOLL AS DITTACOLL WITH(NOLOCK)
                                  WHERE  DITTACOLL.CG86_INDTIPO = 0
                                     AND CG41_PRIMANOTA.CG41_DITTA_CG18 = DITTACOLL.CG86_DITTACOLL_CG18
                                     AND YEAR(ISNULL(CG41_PRIMANOTA.CG41_DATAREGIVA, CG41_PRIMANOTA.CG41_DATAREG)) = DITTACOLL.CG86_ANNOIVA), CG41_PRIMANOTA.CG41_DITTA_CG18) END AS CG86_CODATTIVITA
FROM            CG50_MOVPAGSOSP WITH(NOLOCK)
INNER JOIN      CG49_PAGSOSP WITH(NOLOCK)
             ON CG50_MOVPAGSOSP.CG50_DITTA_CG18 = CG49_PAGSOSP.CG49_DITTA_CG18
            AND CG50_MOVPAGSOSP.CG50_NUMREG_CG41 = CG49_PAGSOSP.CG49_NUMREG_CG41
            AND CG50_MOVPAGSOSP.CG50_NUMPAG_CG49 = CG49_PAGSOSP.CG49_NUMPAG
INNER JOIN      CG41_PRIMANOTA WITH(NOLOCK)
             ON CG49_PAGSOSP.CG49_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTA_CG18
            AND CG49_PAGSOSP.CG49_REGPN_CG41 = CG41_PRIMANOTA.CG41_NUMREG
INNER JOIN      CG41_PRIMANOTA AS PN_DOCORIG WITH(NOLOCK)
             ON CG49_PAGSOSP.CG49_DITTA_CG18 = PN_DOCORIG.CG41_DITTA_CG18
            AND CG49_PAGSOSP.CG49_NUMREG_CG41 = PN_DOCORIG.CG41_NUMREG
INNER JOIN      CG28_TABCODIVA WITH(NOLOCK)
             ON CG50_MOVPAGSOSP.CG50_CODICE_CG28 = CG28_TABCODIVA.CG28_CODICE
LEFT OUTER JOIN VCG16_ANAGRALLADATA
             ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = PN_DOCORIG.CG41_DITTACF_CG18
            AND VCG16_ANAGRALLADATA.CG44_TIPOCF = PN_DOCORIG.CG41_TIPOCF_CG44
            AND VCG16_ANAGRALLADATA.CG44_CLIFOR = PN_DOCORIG.CG41_CLIFOR_CG44
            AND ISNULL(PN_DOCORIG.CG41_DATADOC, PN_DOCORIG.CG41_DATAREG) BETWEEN ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, '17530101')
                                                                             AND ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, '99991231')
OUTER APPLY     DBO.FNCG07_TABSTATIEST(VCG16_ANAGRALLADATA.CG16_CODICE_CG07, CG41_PRIMANOTA.CG41_DITTA_CG18) AS CG07_TABSTATIEST
LEFT OUTER JOIN CG68_NUMERDESC WITH(NOLOCK)
             ON PN_DOCORIG.CG41_DITTA_CG18 = CG68_NUMERDESC.CG68_DITTA_CG18
            AND PN_DOCORIG.CG41_SEZIONALE = CG68_NUMERDESC.CG68_SEZIONALE
LEFT OUTER JOIN CG32_ANADITTAPSEZ WITH(NOLOCK)
             ON PN_DOCORIG.CG41_DITTA_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18
            AND YEAR(ISNULL(CG41_PRIMANOTA.CG41_DATAREGIVA, CG41_PRIMANOTA.CG41_DATAREG)) = CG32_ANADITTAPSEZ.CG32_ANNO
            AND PN_DOCORIG.CG41_SEZIONALE = CG32_ANADITTAPSEZ.CG32_SEZIONALE
LEFT OUTER JOIN CG86_AZIENDECOLL WITH(NOLOCK)
             ON CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86 = CG86_AZIENDECOLL.CG86_IDATTIVITA
WHERE           CG68_NUMERDESC.CG68_FLGNOLIQIVA = 0

---------------------------------------------------------------------
---            RECORDS DI TIPO 'E' (INCASSI EDITORIA)             ---
---------------------------------------------------------------------
UNION ALL

SELECT          'E' AS TIPODOC,
                INCASSO.CG41_DITTA_CG18,
                INCASSO.CG41_FLGSTPIVA,
                INCASSO.CG41_NUMREG,
                INCASSO.CG41_DATAREG,
                INCASSO.CG41_ANNO_CG19,
                INCASSO.CG41_PROGESER_CG19,
                FATTURA.CG41_INDTIPOREG,
                FATTURA.CG41_SEZIONALE,
                CG68_NUMERDESC.CG68_INDREGIONE,
                INCASSO.CG41_CODICE_CG33,
                NULL AS CG33_CAUSALEIVA,
                INCASSO.CG41_DATAREGIVA,
                INCASSO.CG41_INDTIPOMOV,
                CGE3_MOVPAGEDITORIA.CGE3_CODICE_CG28 AS CG43_ALIQIVA1_CG28,
                NULL AS CG43_ALIQIVA2_CG28,
                ISNULL((CASE INCASSO.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CGE3_MOVPAGEDITORIA.CGE3_IMPONIBILE
                        ELSE CGE3_MOVPAGEDITORIA.CGE3_IMPONIBILE END), 0) AS CG43_IMPONIBILE,
                ISNULL((CASE INCASSO.CG41_FLGSEGNOIVA
                        WHEN 1 THEN -CGE3_MOVPAGEDITORIA.CGE3_IMPOSTA
                        ELSE CGE3_MOVPAGEDITORIA.CGE3_IMPOSTA END), 0) AS CG43_IMPOSTA,
      	        0 AS CG43_IMPOSTAND,
                INCASSO.CG41_FLGSEGNOIVA,
                NULL AS CG43_NUMRIGAIVA,
                CGE3_MOVPAGEDITORIA.CGE3_INDTIPO AS CG43_INDTIPO,
      	        0 AS CG43_CAUSALEIVA,
                0 AS CG43_INDDETRIVA,
                0 AS CG43_INDPRORATA,
                CG28_TABCODIVA.CG28_DESCR,
                CG28_TABCODIVA.CG28_TIPOLOGIA,
                CG28_TABCODIVA.CG28_PERCIVA,
                CG28_TABCODIVA.CG28_ALIQIVAVENT,
                CG28_TABCODIVA.CG28_FLGCORRVENT,
                CG28_TABCODIVA.CG28_FLGINDET,
                CG28_TABCODIVA.CG28_PERCINDET,
                CG28_TABCODIVA.CG28_CODPLAFOND,
                CG28_TABCODIVA.CG28_INDTIPOPART,
                CG28_TABCODIVA.CG28_PERCFORF,
                CG28_TABCODIVA.CG28_FLGAUTOUE,
                CG28_TABCODIVA.CG28_FLGNOTVAR,
                CG28_TABCODIVA.CG28_FLGAGRI,
                CG28_TABCODIVA.CG28_FLGESCLUDIBLACKLIST,
				0 AS CG28_FLGMOSSGEST,
				NULL AS CG28_MOSSPERC,
				0 AS CG28_FLGMOSSRID,
				NULL AS CG28_MOSSCOD_CG07,
				NULL AS CG07_MOSSDESCR,
                NULL AS CG28_FLGAGRI_AGRI, 
                NULL AS CG28_DESCR_AGRI, 
                NULL AS CG28_TIPOLOGIA_AGRI,	
                NULL AS CG28_PERCIVA_AGRI, 
                NULL AS CG28_CODPLAFOND_AGRI,
                NULL AS CG28_PERCFORF_AGRI,
                FATTURA.CG41_DATAREGIVA AS CG41_DTREGIVAORIG,
                INCASSO.CG41_NUMDOC,
                INCASSO.CG41_NUMDOCORIG,
                INCASSO.CG41_DATADOC,
                FATTURA.CG41_DITTACF_CG18,
                FATTURA.CG41_TIPOCF_CG44,
                FATTURA.CG41_CLIFOR_CG44,
                VCG16_ANAGRALLADATA.CG44_CODICE_CG16,
                ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAG), '') + ' ' + ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAGEX), '') AS CG16_RAGSOANAG,
                VCG16_ANAGRALLADATA.CG16_CODICE_CG07,
                VCG16_ANAGRALLADATA.CG16_FLGNOBLACKLIST,
      	        ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) AS CG07_INDTIPOSTATO,
                CG07_TABSTATIEST.CG07_DATACEE,
                CG07_TABSTATIEST.CG07_DATAINIBLACKLIST,
                CG07_TABSTATIEST.CG07_DATAFINBLACKLIST,
                CAST(CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0
                          THEN VCG16_ANAGRALLADATA.CG16_PARTIVA_EST
                          ELSE VCG16_ANAGRALLADATA.CG16_PARTIVA END AS VARCHAR(20)) AS CG16_PARTIVA,
				VCG16_ANAGRALLADATA.CG16_CODFISCALE AS CG16_CODFISCALE,
                ISNULL(INCASSO.CG41_IMPTOTALE, 0) AS CG41_IMPTOTALE,
                ISNULL(INCASSO.CG41_IMPTOTALEVAL, 0) AS CG41_IMPTOTALEVAL,
                INCASSO.CG41_CODICE_CG08,
                INCASSO.CG41_FLGDOCBIS,
                INCASSO.CG41_RIFPADRE,
                INCASSO.CG41_RIFFIGLIA,
                INCASSO.CG41_TIPODOC,
                INCASSO.CG41_FLGSTPTOTIVA,
                INCASSO.CG41_DATADOCRIFNOTEVAR,
                FATTURA.CG41_CODICE_CG31,
                FATTURA.CG41_ANAGBLACKLIST_CG16,
                NULL AS CGM2_INDTIPOMOV,
                NULL AS CGM2_PERCFORF,
                NULL AS CGM2_MARGINE,
                NULL AS CGM2_RETTCOSTO,
                CG68_NUMERDESC.CG68_PUNTOVEN_CG7A,
                CG68_NUMERDESC.CG68_INDINTRA1213,
		        CASE WHEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, 0) <> 0
                     THEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, INCASSO.CG41_DITTA_CG18)
                     ELSE ISNULL((SELECT TOP 1 (DITTACOLL.CG86_CODATTIVITA)
                                  FROM   CG86_AZIENDECOLL AS DITTACOLL WITH(NOLOCK)
                                  WHERE  DITTACOLL.CG86_INDTIPO = 0
                                     AND INCASSO.CG41_DITTA_CG18 = DITTACOLL.CG86_DITTACOLL_CG18
                                     AND YEAR(ISNULL(INCASSO.CG41_DATAREGIVA, INCASSO.CG41_DATAREG)) = DITTACOLL.CG86_ANNOIVA), INCASSO.CG41_DITTA_CG18) END AS CG86_CODATTIVITA
FROM            CGE3_MOVPAGEDITORIA WITH(NOLOCK)
INNER JOIN      CGE2_PAGEDITORIA WITH(NOLOCK)
             ON CGE3_MOVPAGEDITORIA.CGE3_DITTA_CG18 = CGE2_PAGEDITORIA.CGE2_DITTA_CG18
		    AND CGE3_MOVPAGEDITORIA.CGE3_NUMREG_CG41 = CGE2_PAGEDITORIA.CGE2_NUMREG_CG41
		    AND CGE3_MOVPAGEDITORIA.CGE3_NUMPAG_CGE2 = CGE2_PAGEDITORIA.CGE2_NUMPAG
INNER JOIN      CG41_PRIMANOTA INCASSO WITH(NOLOCK)
             ON CGE2_PAGEDITORIA.CGE2_DITTA_CG18 = INCASSO.CG41_DITTA_CG18
		    AND CGE2_PAGEDITORIA.CGE2_REGPN_CG41 = INCASSO.CG41_NUMREG
INNER JOIN      CG28_TABCODIVA WITH(NOLOCK)
             ON CGE3_MOVPAGEDITORIA.CGE3_CODICE_CG28 = CG28_TABCODIVA.CG28_CODICE
INNER JOIN      CG41_PRIMANOTA FATTURA WITH(NOLOCK)
             ON CGE2_PAGEDITORIA.CGE2_DITTA_CG18 = FATTURA.CG41_DITTA_CG18
		    AND CGE2_PAGEDITORIA.CGE2_NUMREG_CG41 = FATTURA.CG41_NUMREG
LEFT OUTER JOIN VCG16_ANAGRALLADATA
             ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = FATTURA.CG41_DITTACF_CG18
            AND VCG16_ANAGRALLADATA.CG44_TIPOCF = FATTURA.CG41_TIPOCF_CG44
            AND VCG16_ANAGRALLADATA.CG44_CLIFOR = FATTURA.CG41_CLIFOR_CG44
            AND ISNULL(FATTURA.CG41_DATADOC, FATTURA.CG41_DATAREG) BETWEEN ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, '17530101')
                                                                       AND ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, '99991231')
---
OUTER APPLY     DBO.FNCG07_TABSTATIEST(VCG16_ANAGRALLADATA.CG16_CODICE_CG07, INCASSO.CG41_DITTA_CG18) AS CG07_TABSTATIEST
LEFT OUTER JOIN CG68_NUMERDESC WITH(NOLOCK)
             ON FATTURA.CG41_DITTA_CG18 = CG68_NUMERDESC.CG68_DITTA_CG18
            AND FATTURA.CG41_SEZIONALE = CG68_NUMERDESC.CG68_SEZIONALE
LEFT OUTER JOIN CG32_ANADITTAPSEZ WITH(NOLOCK)
             ON FATTURA.CG41_DITTA_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18
            AND YEAR(ISNULL(INCASSO.CG41_DATAREGIVA, INCASSO.CG41_DATAREG)) = CG32_ANADITTAPSEZ.CG32_ANNO
            AND FATTURA.CG41_SEZIONALE = CG32_ANADITTAPSEZ.CG32_SEZIONALE
LEFT OUTER JOIN CG86_AZIENDECOLL WITH(NOLOCK)
             ON CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86 = CG86_AZIENDECOLL.CG86_IDATTIVITA
WHERE           CG68_NUMERDESC.CG68_FLGNOLIQIVA = 0

---------------------------------------------------------------------
---    RECORDS DI TIPO 'U' (REGIME DEL MARGINE PER BENI USATI)    ---
---------------------------------------------------------------------
UNION ALL

SELECT          'U' AS TIPODOC,   
                CG41_PRIMANOTA.CG41_DITTA_CG18, 
                CG41_PRIMANOTA.CG41_FLGSTPIVA, 
                CG41_PRIMANOTA.CG41_NUMREG, 
                CG41_PRIMANOTA.CG41_DATAREG, 
                CG41_PRIMANOTA.CG41_ANNO_CG19, 
                CG41_PRIMANOTA.CG41_PROGESER_CG19, 
                CG41_PRIMANOTA.CG41_INDTIPOREG, 
                CG41_PRIMANOTA.CG41_SEZIONALE,
                CG68_NUMERDESC.CG68_INDREGIONE, 
                CG41_PRIMANOTA.CG41_CODICE_CG33, 
                ISNULL(CG33_TABCAU.CG33_CAUSALEIVA, CG33_TABCAU.CG33_CODICE) AS CG33_CAUSALEIVA,
                CG41_PRIMANOTA.CG41_DATAREGIVA,
                CG41_PRIMANOTA.CG41_INDTIPOMOV,
                CGM2_MOVBENIUSATI.CGM2_CODICE_CG28 AS CG43_ALIQIVA1_CG28,
                NULL AS CG43_ALIQIVA2_CG28, 
                ISNULL(CGM2_MOVBENIUSATI.CGM2_IMPONIBILE, 0) + ISNULL(CGM2_MOVBENIUSATI.CGM2_IMPOSTA,0) AS CG43_IMPONIBILE, 
                0 AS CG43_IMPOSTA,
                0 AS CG43_IMPOSTAND, 
                CG41_PRIMANOTA.CG41_FLGSEGNOIVA,
                CG43_MOVIVA.CG43_NUMRIGAIVA, 
                CG43_MOVIVA.CG43_INDTIPO,
                CG43_MOVIVA.CG43_CAUSALEIVA,
                CG43_MOVIVA.CG43_INDDETRIVA,
                CG43_MOVIVA.CG43_INDPRORATA, 
                CG28_TABCODIVA.CG28_DESCR, 
                CG28_TABCODIVA.CG28_TIPOLOGIA,	
                CG28_TABCODIVA.CG28_PERCIVA, 
                CG28_TABCODIVA.CG28_ALIQIVAVENT, 
                CG28_TABCODIVA.CG28_FLGCORRVENT, 
                CG28_TABCODIVA.CG28_FLGINDET, 
                CG28_TABCODIVA.CG28_PERCINDET, 
                CG28_TABCODIVA.CG28_CODPLAFOND,
                CG28_TABCODIVA.CG28_INDTIPOPART,
                CG28_TABCODIVA.CG28_PERCFORF,
                CG28_TABCODIVA.CG28_FLGAUTOUE,
                CG28_TABCODIVA.CG28_FLGNOTVAR,
                CG28_TABCODIVA.CG28_FLGAGRI,
                CG28_TABCODIVA.CG28_FLGESCLUDIBLACKLIST,
				0 AS CG28_FLGMOSSGEST,
				NULL AS CG28_MOSSPERC,
				0 AS CG28_FLGMOSSRID,
				NULL AS CG28_MOSSCOD_CG07,
				NULL AS CG07_MOSSDESCR,
                NULL AS CG28_FLGAGRI_AGRI, 
                NULL AS CG28_DESCR_AGRI, 
                NULL AS CG28_TIPOLOGIA_AGRI,	
                NULL AS CG28_PERCIVA_AGRI, 
                NULL AS CG28_CODPLAFOND_AGRI,
                NULL AS CG28_PERCFORF_AGRI,
                NULL AS CG41_DTREGIVAORIG, 
                CG41_PRIMANOTA.CG41_NUMDOC,
                CG41_PRIMANOTA.CG41_NUMDOCORIG,
                CG41_PRIMANOTA.CG41_DATADOC,
                CG41_PRIMANOTA.CG41_DITTACF_CG18,
                CG41_PRIMANOTA.CG41_TIPOCF_CG44,
                CG41_PRIMANOTA.CG41_CLIFOR_CG44,
                VCG16_ANAGRALLADATA.CG44_CODICE_CG16,
                ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAG), '') + ' ' + ISNULL(RTRIM(VCG16_ANAGRALLADATA.CG16_RAGSOANAGEX), '') AS CG16_RAGSOANAG,
                VCG16_ANAGRALLADATA.CG16_CODICE_CG07,
                VCG16_ANAGRALLADATA.CG16_FLGNOBLACKLIST,
      	        ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) AS CG07_INDTIPOSTATO,
                CG07_TABSTATIEST.CG07_DATACEE,
                CG07_TABSTATIEST.CG07_DATAINIBLACKLIST,
                CG07_TABSTATIEST.CG07_DATAFINBLACKLIST,
                CAST(CASE WHEN ISNULL(CG07_TABSTATIEST.CG07_INDTIPOSTATO, -1) = 0
                          THEN VCG16_ANAGRALLADATA.CG16_PARTIVA_EST
                          ELSE VCG16_ANAGRALLADATA.CG16_PARTIVA END AS VARCHAR(20)) AS CG16_PARTIVA,
				VCG16_ANAGRALLADATA.CG16_CODFISCALE AS CG16_CODFISCALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALE, 0) AS CG41_IMPTOTALE,
                ISNULL(CG41_PRIMANOTA.CG41_IMPTOTALEVAL, 0) AS CG41_IMPTOTALEVAL,
                CG41_PRIMANOTA.CG41_CODICE_CG08,
                CG41_PRIMANOTA.CG41_FLGDOCBIS,
                CG41_PRIMANOTA.CG41_RIFPADRE,
                CG41_PRIMANOTA.CG41_RIFFIGLIA,
                CG41_PRIMANOTA.CG41_TIPODOC,
                CG41_PRIMANOTA.CG41_FLGSTPTOTIVA,
                CG41_PRIMANOTA.CG41_DATADOCRIFNOTEVAR,
                CG41_PRIMANOTA.CG41_CODICE_CG31,
                CG41_PRIMANOTA.CG41_ANAGBLACKLIST_CG16,
                CGM2_MOVBENIUSATI.CGM2_INDTIPOMOV,
                CGM2_MOVBENIUSATI.CGM2_PERCFORF,
                ISNULL(CGM2_MOVBENIUSATI.CGM2_MARGINE, 0) AS CGM2_MARGINE,
                ISNULL(CGM2_MOVBENIUSATI.CGM2_RETTCOSTO, 0) AS CGM2_RETTCOSTO,
                CG68_NUMERDESC.CG68_PUNTOVEN_CG7A,
                CG68_NUMERDESC.CG68_INDINTRA1213,
		        CASE WHEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, 0) <> 0
                     THEN ISNULL(CG86_AZIENDECOLL.CG86_CODATTIVITA, CG41_PRIMANOTA.CG41_DITTA_CG18)
                     ELSE ISNULL((SELECT TOP 1 (DITTACOLL.CG86_CODATTIVITA)
                                  FROM   CG86_AZIENDECOLL AS DITTACOLL WITH(NOLOCK)
                                  WHERE  DITTACOLL.CG86_INDTIPO = 0
                                     AND CG41_PRIMANOTA.CG41_DITTA_CG18 = DITTACOLL.CG86_DITTACOLL_CG18
                                     AND YEAR(ISNULL(CG41_PRIMANOTA.CG41_DATAREGIVA, CG41_PRIMANOTA.CG41_DATAREG)) = DITTACOLL.CG86_ANNOIVA), CG41_PRIMANOTA.CG41_DITTA_CG18) END AS CG86_CODATTIVITA
FROM            CG41_PRIMANOTA WITH(NOLOCK)
INNER JOIN      CG43_MOVIVA WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG43_MOVIVA.CG43_DITTA_CG18
            AND CG41_PRIMANOTA.CG41_NUMREG = CG43_MOVIVA.CG43_NUMREG_CG41
INNER JOIN      CG28_TABCODIVA WITH(NOLOCK)
             ON CG43_MOVIVA.CG43_ALIQIVA1_CG28 = CG28_TABCODIVA.CG28_CODICE
INNER JOIN      CG33_TABCAU WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_CODICE_CG33 = CG33_TABCAU.CG33_CODICE
INNER JOIN      CG42_MOVCONT WITH(NOLOCK)
             ON CG43_MOVIVA.CG43_DITTA_CG18 = CG42_MOVCONT.CG42_DITTA_CG18 
            AND CG43_MOVIVA.CG43_NUMREG_CG41 = CG42_MOVCONT.CG42_NUMREG_CG41 
            AND CG43_MOVIVA.CG43_NUMRIGAIVA = CG42_MOVCONT.CG42_PROGIVA_CG43 
INNER JOIN      CGM2_MOVBENIUSATI WITH(NOLOCK)
             ON CG42_MOVCONT.CG42_DITTA_CG18 = CGM2_MOVBENIUSATI.CGM2_DITTA_CG18
            AND CG42_MOVCONT.CG42_NUMREG_CG41 = CGM2_MOVBENIUSATI.CGM2_NUMREG_CG41
            AND CG42_MOVCONT.CG42_NUMRIGACONT = CGM2_MOVBENIUSATI.CGM2_NUMRIGACONT_CG42
LEFT OUTER JOIN VCG16_ANAGRALLADATA
             ON VCG16_ANAGRALLADATA.CG44_DITTA_CG18 = CG41_PRIMANOTA.CG41_DITTACF_CG18
            AND VCG16_ANAGRALLADATA.CG44_TIPOCF = CG41_PRIMANOTA.CG41_TIPOCF_CG44
            AND VCG16_ANAGRALLADATA.CG44_CLIFOR = CG41_PRIMANOTA.CG41_CLIFOR_CG44
            AND ISNULL(CG41_PRIMANOTA.CG41_DATADOC, CG41_PRIMANOTA.CG41_DATAREG) BETWEEN ISNULL(VCG16_ANAGRALLADATA.DATAINIZIOVALIDITA, '17530101')
                                                                                     AND ISNULL(VCG16_ANAGRALLADATA.DATAFINEVALIDITA, '99991231')
OUTER APPLY     DBO.FNCG07_TABSTATIEST(VCG16_ANAGRALLADATA.CG16_CODICE_CG07, CG41_PRIMANOTA.CG41_DITTA_CG18) AS CG07_TABSTATIEST
LEFT OUTER JOIN CG68_NUMERDESC WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG68_NUMERDESC.CG68_DITTA_CG18
            AND CG41_PRIMANOTA.CG41_SEZIONALE = CG68_NUMERDESC.CG68_SEZIONALE
LEFT OUTER JOIN CG32_ANADITTAPSEZ WITH(NOLOCK)
             ON CG41_PRIMANOTA.CG41_DITTA_CG18 = CG32_ANADITTAPSEZ.CG32_DITTA_CG18
            AND YEAR(ISNULL(CG41_PRIMANOTA.CG41_DATAREGIVA, CG41_PRIMANOTA.CG41_DATAREG)) = CG32_ANADITTAPSEZ.CG32_ANNO
            AND CG41_PRIMANOTA.CG41_SEZIONALE = CG32_ANADITTAPSEZ.CG32_SEZIONALE
LEFT OUTER JOIN CG86_AZIENDECOLL WITH(NOLOCK)
             ON CG32_ANADITTAPSEZ.CG32_IDATTIVITA_CG86 = CG86_AZIENDECOLL.CG86_IDATTIVITA
WHERE           CG43_MOVIVA.CG43_INDTIPO IN (30, 31, 32, 33, 34)
            AND CG68_NUMERDESC.CG68_FLGNOLIQIVA = 0

